﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using System.Drawing;

namespace Edu.Library.Helpers
{
    public static class ReflectionHelper
    {
        private static readonly Dictionary<string, List<PropertyInfo>> _properties = new Dictionary<string, List<PropertyInfo>>();
        private static readonly Dictionary<string, List<MethodInfo>> _methods = new Dictionary<string, List<MethodInfo>>();

        public static Type LoadType(string typeName, params Assembly[] assemblies)
        {
            var type = Type.GetType(typeName);
            if (type != null) return type;

            if (assemblies == null) return null;

            foreach(var assembly in assemblies)
            {
                var assemblyType = assembly.GetType(typeName);
                if (assemblyType != null) return assemblyType;
            }

            return null;
        }

        public static List<PropertyInfo> TryGetProperties(string typeName, params Assembly[] assemblies)
        {
            try
            {
                if (string.IsNullOrWhiteSpace(typeName)) return null;

                var type = LoadType(typeName, assemblies);

                var properties = type
                    .GetProperties()
                    .ToList();
                _properties.Add(typeName, properties);
                return properties;
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.ToString());
                return null;
            }
        }

        public static List<PropertyInfo> GetProperties(string typeName, params Assembly[] assemblies)
        {
            List<PropertyInfo> properties;

            if(_properties.ContainsKey(typeName))
            {
                properties = _properties[typeName];
            }
            else
            {
                properties = TryGetProperties(typeName, assemblies);
            }

            if(properties == null)
            {
                properties= new List<PropertyInfo>();
            }

            return properties;
        }


        public static List<MethodInfo> TryGetMethods(string typeName, params Assembly[] assemblies)
        {
            try
            {
                if (string.IsNullOrWhiteSpace(typeName)) return null;

                var type = LoadType(typeName, assemblies);

                var methods = type
                    .GetMethods()
                    .ToList();
                _methods.Add(typeName, methods);
                return methods;
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.ToString());
                return null;
            }
        }

        public static List<MethodInfo> GetMethods(string typeName, params Assembly[] assemblies)
        {
            List<MethodInfo> methods;

            if (_methods.ContainsKey(typeName))
            {
                methods = _methods[typeName];
            }
            else
            {
                methods = TryGetMethods(typeName, assemblies);
            }

            if (methods == null)
            {
                methods = new List<MethodInfo>();
            }

            return methods;
        }


    }
}
